###############################################################################
# OpenVAS Vulnerability Test
# $Id: samba_multiple_vulnerabilities.nasl 5567 2009-10-15 18:14:59Z mime $
#
# Samba multiple vulnerabilities 
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100306);
 script_bugtraq_id(36363,36572,36573);
 script_cve_id("CVE-2009-2813","CVE-2009-2948","CVE-2009-2906");
 script_version ("1.0-$Revision: 5567 $");

 script_name("Samba multiple vulnerabilities");

desc = "Overview:
Samba is prone to multiple vulnerabilities including a vulnerability
that may allow attackers to bypass certain security restrictions, an
information-disclosure vulnerability and a remote denial-of-service
vulnerability.

Successful exploits may allow attackers to gain access to resources
that aren't supposed to be shared, allow attackers to obtain sensitive
information that may aid in further attacks and to cause the
application to consume excessive CPU resources, denying service to
legitimate users. 

Versions prior to Samba 3.4.2, 3.3.8, 3.2.15, and 3.0.37 are
vulnerable.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/36363
http://www.securityfocus.com/bid/36573
http://www.securityfocus.com/bid/36572
http://www.samba.org/samba/security/CVE-2009-2813.html
http://www.samba.org/samba/security/CVE-2009-2948.html
http://www.samba.org/samba/security/CVE-2009-2906.html
http://www.samba.org/samba/history/security.html
http://us1.samba.org/samba/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Samba is prone to multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("smb_nativelanman.nasl");
 script_require_ports(139, 445);
 script_require_keys("SMB/NativeLanManager");
 exit(0);
}

include("version_func.inc");

port = get_kb_item("SMB/transport");
if(!port)port = 139;

if(!get_port_state(port))exit(0);

if(!lanman = get_kb_item("SMB/NativeLanManager"))exit(0);
if("Samba" >!< lanman)exit(0);

if(!version = eregmatch(pattern:"Samba ([0-9.]+)", string: lanman))exit(0);
if(isnull(version[1]))exit(0);

if(version_in_range(version:version[1], test_version:"3.4", test_version2: "3.4.1") ||
   version_in_range(version:version[1], test_version:"3.3", test_version2: "3.3.7") ||
   version_in_range(version:version[1], test_version:"3.2", test_version2: "3.2.14") ||
   version_in_range(version:version[1], test_version:"3.0", test_version2: "3.0.36"))
   {
    security_warning(port:port);
    exit(0);
   }  

exit(0);
