###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_adobe_jrun_detect.nasl 4081 2009-08-25 18:14:24Z aug $
#
# Sun Adobe JRun Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900822);
  script_version("$Revision: 1.0 $");
  script_name("Sun Adobe JRun Version Detection");

  desc = "
  Overview: This script detects the installed version of Adobe JRun and
  sets the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of Adobe JRun");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8000);
  exit(0);
}


include("http_func.inc");

jrunPort = get_http_port(default:8000);
if(!jrunPort){
  jrunPort = 8000;
}

if(!get_port_state(jrunPort)){
  exit(0);
}

sndReq = http_get(item:string("/"), port:jrunPort);
rcvRes = http_send_recv(port:jrunPort, data:sndReq);

if(egrep(pattern:"Server: JRun Web Server", string:rcvRes) &&
   egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
{
  # Grep the Adobe/Macromedia JRun Version from Response
  jrunVer = eregmatch(pattern:">Version ([0-9.]+)", string:rcvRes);

  if(jrunVer[1] != NULL){
    set_kb_item(name:"/Adobe/JRun/Ver", value:jrunVer[1]);
  }
}
