##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apapche_apr-utils_detect.nasl 2745 2009-06-23 15:30:37Z jun $
#
# Apache APR-Utils Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# Updated to Detect Zero Series Versions
#  - By Antu Sanadi <santu@secpod.com> On 2009-08-14
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900571);
  script_version("$ Revision:1.1 $");
  script_name("Apache APR-Utils Version Detection");
  desc = "

  Overview : This script retrieves the version of Apache APR-Utils
  and saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set Version of Apache APR-Utils in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

util_sock = ssh_login_or_reuse_connection();
if(!util_sock){
  exit(0);
}

foreach path (make_list("apu-config" ,"apu-1-config"))
{
  getPath = find_bin(prog_name:path, sock:util_sock);

  foreach binaryFile (getPath)
  {
    utilsVer = get_bin_version(full_prog_name:chomp(binaryFile), sock:util_sock,
                               version_argv:"--version", ver_pattern:"[0-9.]+");

    if(utilsVer[0] != NULL){
      set_kb_item(name:"Apache/APR-Utils/Ver", value:utilsVer[0]);
    }
  }
}
ssh_close_connection();
