###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apache_tiles_detect.nasl 1632 2009-04-20 19:32:24Z apr $
#
# Apache Tiles Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900493);
  script_version("Revision: 1.0 ");
  script_name("Apache Tiles Version Detection");
  desc = "
  Overview: This script detects the installed version of Apache Tiles and sets
  the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of Apache Tiles");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");

port = get_http_port(default:8080);
if(!port){
  port = 8080;
}

if(!get_port_state(port)){
  exit(0);
}

foreach dir (make_list("/", "/tiles", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/apidocs/index.html \r\n\r\n HTTP/1.1"), port:port);
  rcvRes = http_send_recv(port:port, data:sndReq);

  if(rcvRes == NULL){
    exit(0);
  }

  if("packageFrame" >< rcvRes || "classFrame" >< rcvRes)
  {
    request =  http_get(item:string(dir, "/apidocs/org/apache/tiles/Definition.html " +
                                         "\r\n\r\n HTTP/1.1"), port:port);
    response = http_send_recv(port:port, data:request);

    if(response == NULL)
    {
      request =  http_get(item:string(dir, "/apidocs/org/apache/tiles/definition/digester" +
                                           "/DigesterDefinitionsReader.FillDefinitionRule.html" +
                                           "\r\n\r\n HTTP/1.1"), port:port);
      response = http_send_recv(port:port, data:request);
    }

    if(response != NULL)
    {
      version = eregmatch(pattern:">([0-9]\.[0-9]\.[0-9.]+)", string:response);
      if(version[1] != NULL){
        set_kb_item(name:"www/" + port + "/Apache/Tiles", value:version[1] + " under " + dir);
      }
    }
  }
}
