##############################################################################
#
#  Apple iTunes Local Privilege Escalation Vulnerability 
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/12
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0191
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900122);
 script_bugtraq_id(31089);
 script_cve_id("CVE-2008-3636");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("Apple iTunes Local Privilege Escalation Vulnerability");
 script_summary("Check for vulnerable version of Apple iTunes");
 desc = "
 Overview : The host is installed with Apple iTunes, which prone to privilege
 escalation vulnerability.

 Vulnerability Insight :

        The flaw is caused due to integer overflow error in a third-party
        driver bundled with iTune.

        Impact : Successful exploitation will allow local users to obtain elevated
        privileges thus compromising the affected system. 

 Impact Level : System

 Affected Software/OS :
        Apple iTunes versions prior to 8.0 on Windows
 
 Fix : Upgrade to version 8.0,
 http://www.apple.com/itunes/download/

 References : http://securitytracker.com/alerts/2008/Sep/1020839.html
 http://lists.apple.com/archives/security-announce//2008/Sep/msg00001.html

 CVSS Score :
        CVSS Base Score     : 6.6 (AV:L/AC:M/Au:SI/C:C/I:C/A:C)
        CVSS Temporal Score : 4.9
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl",
                     "secpod_apple_itunes_detection_win_900123.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 if(egrep(pattern:"^([0-6]\..*|7\.[0-9](\..*)?)$", 
          string:get_kb_item("iTunes/Win/Ver"))){
        security_warning(0);
 }
