###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apple_safari_mult_vuln_aug09.nasl 4043 2009-08-18 16:20:26Z aug $
#
# Apple Safari Multiple Vulnerabilities - Aug09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900912);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2195", "CVE-2009-2196", "CVE-2009-2199",
                "CVE-2009-2200");
  script_bugtraq_id(36022, 36023, 36024, 36026);
  script_name("Apple Safari Multiple Vulnerabilities - Aug09");
  desc = "

  Overview: This host is installed with Apple Safari Web Browser and is prone
  to multiple vulnerabilities.

  Vulnerability Insight:
  - An error in WebKit while parsing malicious floating point numbers can be
    exploited to cause buffer overflows.
  - An unspecified error in the Top Sites feature can be exploited to place a
    malicious  web site in the Top Sites view when a user visits a specially
    crafted web page.
  - Incomplete blacklist vulnerability in WebKit can be exploited via
    unspecified homoglyphs.
  - An error in WebKit in the handling of the 'pluginspage' attribute of the
    'embed' element can be exploited to launch arbitrary file: URLs and obtain
    sensitive information via a crafted HTML document.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code, bypass
  security restrictions, gain sensitive information and can cause Denial of
  Service.

  Impact Level: System/Application

  Affected Software/OS:
  Apple Safari version prior to 4.0.3.

  Fix: Upgrade to Safari version 4.0.3
  http://www.apple.com/support/downloads

  References:
  http://support.apple.com/kb/HT3733
  http://secunia.com/advisories/36269/
  http://lists.apple.com/archives/security-announce/2009/Aug/msg00002.html
  http://securethoughts.com/2009/08/hijacking-safari-4-top-sites-with-phish-bombs

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");

if(!safariVer){
  exit(0);
}

# Check for Apple Safari Version < 4.0.3 (4.31.9.1)
if(version_is_less(version:safariVer, test_version:"4.31.9.1")){
  security_hole(0);
}
