###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apple_safari_mult_vuln_june09.nasl 2511 2009-06-01 10:40:43Z June $
#
# Apple Safari Multiple Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900723);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0162");
  script_bugtraq_id(34925);
  script_name("Apple Safari Multiple Vulnerabilities");
  desc = "

  Overview: The host is running Apple Safari web browser and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Browser faces input validation error while handing 'feed:' protocol based
  URLs which causes injection of arbitrary codes.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes and can
  cause XSS, Buffer Overflow, JavaScript code injection and denial of service in
  the context of an affected system.

  Impact level: System/Application

  Affected Software/OS:
  Apple Safari version prior to 3.2.3 and 4 Beta on Windows

  Fix: Upgrade to Safari version 3.2.3 or later
  http://www.apple.com/safari/download

  References:
  http://secunia.com/advisories/35056
  http://www.vupen.com/english/advisories/2009/1298
  http://lists.apple.com/archives/security-announce/2009/May/msg00000.html
  http://lists.apple.com/archives/security-announce/2009/May/msg00001.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(!safariVer){
  exit(0);
}

# Check for Safari version prior to 3.2.3 (3.525.29.0)
if(version_is_less(version:safariVer, test_version:"3.525.29.0") ||
   version_in_range(version:safariVer, test_version:"4.0",
                    test_version2:"4.28.17.0")){ # 4 Beta range
  security_warning(0);
}
