###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_asterisk_rtp_text_frames_dos_vuln.nasl 3742 2009-07-31 22:50:24Z jul $
#
# Asterisk RTP Text Frames Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900812);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2651");
  script_bugtraq_id(35837);
  script_name("Asterisk RTP Text Frames Denial Of Service Vulnerability");
  desc = "

  Overview:
  This host has Asterisk installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  Error in main/rtp.c file which can be exploited via an RTP text frame without
  a certain delimiter that triggers a NULL pointer dereference and the
  subsequent calculation to an invalid pointer.

  Impact:
  Successful exploitation will let the attacker cause Denial of Service
  in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Asterisk version 1.6.1 and before 1.6.1.2 on Linux.

  Fix: Upgrade to Asterisk version 1.6.1.2 or latest or apply the patch,
  http://www.asterisk.org/downloads
  http://downloads.asterisk.org/pub/security/AST-2009-004-1.6.1.diff.txt

  *****
  NOTE: Please ignore the warning if the patch is applied.
  *****

  References:
  http://secunia.com/advisories/36039/
  http://www.vupen.com/english/advisories/2009/2067
  http://downloads.asterisk.org/pub/security/AST-2009-004.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Asterisk");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_asterisk_detect.nasl");
  script_require_keys("Asterisk-PBX/Ver");
  exit(0);
}


include("version_func.inc");

asteriskPort = get_kb_item("Services/udp/sip");
if(!asteriskPort)exit(0);
if(!get_udp_port_state(asteriskPort))exit(0);

asteriskVer = get_kb_item("Asterisk-PBX/Ver");
if(!asteriskVer){
  exit(0);
}

# Check for Asterisk version 1.6.1 < 1.6.1.2
if(version_in_range(version:asteriskVer, test_version:"1.6.1",
                                         test_version2:"1.6.1.1")){
  security_warning(port:asteriskPort, proto:"udp");
}
