###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_bitdefender_prdts_detect.nasl 866 2009-03-17 12:30:24Z mar $
#
# BitDefender Product(s) Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900326);
  script_version("Revision: 1.0 $");
  script_name("BitDefender Product(s) Version Detection");
  desc = "
  Overview: This script retrieves the installed version of BitDefender
  Product(s) and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets version in KB for BitDefender Product(s)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

bitKey = "SOFTWARE\BitDefender\About";
bitName = registry_get_sz(key:bitKey, item:"ProductName");

if(bitName)
{
  if("BitDefender Internet Security" >< bitName)
  {
    bitVer = registry_get_sz(key:bitKey, item:"ProductVersion");
    if(bitVer == NULL)
    {
      bitVer = registry_get_sz(key:"SOFTWARE\BitDefender\BitDefender Desktop" +
                                   "\Maintenance\InternetSecurity",
                               item:"ProductVersion");
    }
    if(bitVer){
      set_kb_item(name:"BitDefender/InetSec/Ver", value:bitVer);
    }
  }

  if("BitDefender Antivirus" >< bitName)
  {
    bitVer = registry_get_sz(key:bitKey, item:"ProductVersion");
    if(bitVer == NULL)
    {
      bitVer = registry_get_sz(key:"SOFTWARE\BitDefender\BitDefender Desktop" +
                                   "\Maintenance\Antivirus",
                               item:"ProductVersion");
    }
    if(bitVer){
      set_kb_item(name:"BitDefender/AV/Ver", value:bitVer);
    }
  }
}
