###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_blender_detect_lin.nasl 5657 2009-11-17 18:47:29Z nov $
#
# Blender Version Detection (Linux)
#
# Authors:
# Maneesh KB <kmaneesh@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900251);
  script_version("$Revision: 1.0 $");
  script_name("Blender Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of Blender
  and sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Blender");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

blendPath = find_file(file_name:"blender",file_path:"/",
                  useregex:TRUE, regexpar:"$", sock:sock);

foreach binPath (blendPath)
{
  blendVer = get_bin_version(full_prog_name:chomp(binPath), version_argv:"--version",
                          ver_pattern:"Blender ([0-9.]+)( .sub [0-9]+)?", sock:sock);

  if(blendVer[1] != NULL)
  {
    if ("sub" >< blendVer[2])
    {
      blendVer[2] = ereg_replace(pattern:" \(sub ", string:blendVer[2], replace:"");
      blendVer = blendVer[1] + "." + blendVer[2];
    }
    else
      blendVer = blendVer[1];
    set_kb_item(name:"Blender/Lin/Ver", value:blendVer);
  }
}
ssh_close_connection();
