##############################################################################
#
#  Blue Coat K9 Web Protection Multiple Buffer Overflow Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/01
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0077
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900103);
 script_bugtraq_id(30464,30463);
 script_cve_id("CVE-2007-2752");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Buffer overflow");
 script_name("Blue Coat K9 Web Protection Multiple Buffer Overflow Vulnerabilities");
 script_summary("Check for vulnerable version and prior of Blue Coat");
 desc = "
 Overview : This host is installed with Blue Coat K9 Web Protection, which is
 prone to stack based buffer overflow vulnerability.
	
 Vulnerability Insight :

        The flaws exist due to errors in filter services (k9filter.exe) when
        handling,
        - http version information in responses from a centralised server
          (sp.cwfservice.net).
        - Referer: headers during access to the web-based K9 Web Protection
          Administration interface.
	
        Impact : Successful exploitation could allow remote attackers to cause
        stack based buffer overflow by sending specially crafted malicious
        code containing and overly long http version information and
        reference header.

 Impact Level : System

 Affected Software/OS :
	Blue Coat K9 Web Protection versions 3.2.44 and prior on Windows (All)

 Fix : No solution/patch is available as on 01st August, 2008. Solution details
 will be updated soon once the details are available. For update refer,
 http://www1.k9webprotection.com/aboutk9/index.php

 References :
 http://secunia.com/secunia_research/2007-61/advisory/
 http://secunia.com/secunia_research/2007-64/advisory/

 CVSS Score Report :
        CVSS Base Score     : 9.0 (AV:N/AC:L/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 7.7
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if (!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 blueVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
			       "\Uninstall\Blue Coat K9 Web Protection",
			   item:"DisplayVersion");
 
 if(egrep(pattern:"^([0-2]\..*|3\.([01]\..*|2\.([0-3]?[0-9]|4[0-4])))$",
	  string:blueVer)) {
	security_warning(0);
 }
