###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_bopup_server_detect.nasl 3177 2009-07-04 11:58:02Z jul $
#
# Bopup Communication Server Version Detection
#
# Authors:
# Antu Sanadi <santus@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900686);
  script_version("$Revision: 1.0 $");
  script_name("Bopup Communication Server Version Detection");
  desc = "

  Overview: This script detects the version of Bopup Communication Server and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Bopup Communication Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

bopupPath = registry_get_sz(key:"SOFTWARE\B Labs\Bopup Communication Server",
                            item:"Location");
if(bopupPath)
{
  bopupPath = bopupPath + "bcssrvc.exe";
  share = ereg_replace(pattern:"([A-Za-z]):.*", replace:"\1$", string:bopupPath);
  file = ereg_replace(pattern:"[A-Za-z]:(.*)", replace:"\1", string:bopupPath);

  bopupVer = GetVer(file:file, share:share);
  if(bopupVer != NULL){
    set_kb_item(name:"Bopup/Server/Ver", value:bopupVer);
  }
}
