###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_campsite_mult_vuln.nasl 3105 2009-06-30 16:00:29Z jun $
#
# Campsite 'g_campsiteDir' Remote and Local File Inclusion Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900385);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2181", "CVE-2009-2182", "CVE-2009-2183");
  script_bugtraq_id(35456);
  script_name("Campsite 'g_campsiteDir' Remote and Local File Inclusion Vulnerabilities");
  desc = "

  Overview: This host is running Campsite and is prone to multiple vulnerabilities.

  Vulnerability Insight:
  The multiple flaws are due to,
  - Input validation errors in the 'admin-files','conf/liveuser_configuration.php'
    'include/phorum_load.php',scripts when processing the 'g_campsiteDir'
    parameter.
  - Input validation error in the 'admin-files/templates/list_dir.php' script
    when,processing the 'listbasedir' parameter.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary local
  files, and cause XSS attack, Directory Traversal attack and remote File
  Injection attack on the affected application.

  Impact Level: Application

  Affected Software/OS:
  Campware, Campsite version 3.3.0 RC1 and prior

  Fix:
  No solution or patch is available as on 31th December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://campware.org/

  References:
  http://www.milw0rm.com/exploits/8995
  http://www.vupen.com/english/advisories/2009/1650

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Attack and Version of Campsite");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_campsite_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

campsitePort = get_http_port(default:80);
if(!campsitePort){
  exit(0);
}

campsiteVer = get_kb_item("www/"+ campsitePort + "/Campsite");
if(campsiteVer == NULL){
  exit(0);
}

ver = eregmatch(pattern:"^(.+) under (/.*)$", string:campsiteVer);

# Check for RFI
if(ver[2] != NULL)
{
  if(!safe_checks())
  {
    sndReq = http_get(item:string(ver[2], 'conf/liveuser_configuration.php' +
                      '?GLOBALS[g_campsiteDir]=[SHELL]'), port:campsitePort);
    rcvRes = http_send_recv(port:campsitePort, data:sndReq);
    if("SHELL" >< rcvRes && "No such file or directory" >< rcvRes)
    {
      security_hole(campsitePort);
      exit(0);
    }
  }
}

if(ver[1] != NULL)
{
  # Check for Campsite version 3.3.0 RC1
  if(version_is_less_equal(version:ver[1], test_version:"3.3.0.RC1")){
    security_hole(campsitePort);
  }
}
