###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_divx_web_player_bof_vuln.nasl 1791 2009-04-17 11:45:02Z apr $
#
# DivX Web Player Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900537);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5259");
  script_bugtraq_id(34523);
  script_name("DivX Web Player Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running DivX Web Player which is prone to buffer
  overflow vulnerability.

  Vulnerability Insight:
  This flaw is due to the boundary checking error while processing Stream
  Format 'STRF' chunks which causes heap overflow.

  Impact: Successful exploitation will let the attacker execute arbitrary
  codes within the context of the application by tricking a user into
  opening a crafted DivX file.

  Impact level: System

  Affected Software/OS:
  DivX Web Player 1.4.2.7 and prior on Windows.

  Fix: Update to version 1.4.3.4
  http://www.divx.com/downloads/divx

  References:
  http://en.securitylab.ru/nvd/377996.php
  http://secunia.com/advisories/33196
  http://www.vupen.com/english/advisories/2009/1044

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of DivX Web Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_divx_web_player_detect.nasl");
  script_require_keys("DivX/Web/Player/Ver");
  exit(0);
}


include("version_func.inc");

divxVer = get_kb_item("DivX/Web/Player/Ver");
if(divxVer == NULL){
  exit(0);
}

if(version_is_less(version:divxVer, test_version:"1.4.3.4")){
  security_hole(0);
}
