###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_django_algorithmic_complexity_vuln.nasl 5288 2009-10-26 16:44:17Z oct $
#
# Django Forms Library Algorithmic Complexity Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900882);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3695");
  script_bugtraq_id(36655);
  script_name("Django Forms Library Algorithmic Complexity Vulnerability");
  desc = "
  Overview: The host is running Django and is prone to Algorithmic Complexity
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error within the regular expressions used for
  validation of the 'EmailField' or 'URLField' form fields in Django's forms
  library.

  Impact:
  Successful exploitation will let the attacker to cause a Denial of Service
  due to high CPU consumption via specially crafted email addresses or URLs.

  Impact Level: System/Application

  Affected Software/OS:
  Django version prior to 1.0 before 1.0.4 and 1.1 before 1.1.1

  Fix: Upgrade to Django version 1.0.4 or 1.1.1 or later.
  http://www.djangoproject.com/download/

  References:
  http://secunia.com/advisories/36948/
  http://www.vupen.com/english/advisories/2009/2871
  http://www.djangoproject.com/weblog/2009/oct/09/security/

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Django");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_django_detect_lin.nasl");
  script_require_ports("Services/www", 8000);
  exit(0);
}


include("version_func.inc");

djangoVer = get_kb_item("Django/Linux/Ver");
if(djangoVer)
{
  if(version_in_range(version:djangoVer, test_version:"1.0", test_version2:"1.0.3")||
     version_is_equal(version:djangoVer, test_version:"1.1")){
    security_warning(djangoPort);
  }
}
