###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_f-prot_av_sec_bypass_vuln_lin.nasl 2478 2009-06-01 15:02:22Z may $
#
# F-PROT AntiVirus Security Bypass Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900555);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-1783");
  script_bugtraq_id(34896);
  script_name("F-PROT AntiVirus Security Bypass Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with F-PROT AntiVirus and is prone to
  Security Bypass vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error in the file parsing engine while
  processing specially crafted CAB files.

  Impact:
  Attackers can exploit this issue to bypass the malware detection and
  to execute arbitrary code.

  Impact Level: System/Application

  Affected Software/OS:
  F-PROT AV version 6.0.2 and prior on Linux.

  Fix: No solution or patch is available as on 26th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.f-prot.com/

  References:
  http://xforce.iss.net/xforce/xfdb/50427
  http://blog.zoller.lu/2009/04/advisory-f-prot-frisk-cab-bypass.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.5
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of F-PROT AV");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_f-prot_av_detect_lin.nasl");
  script_require_keys("F-Prot/AV/Linux/Ver");
  exit(0);
}


include("version_func.inc");

avVer = get_kb_item("F-Prot/AV/Linux/Ver");
if(!avVer){
  exit(0);
}

# grep for version 6.0.2 => 6.2.1.4252
if(version_is_less_equal(version:avVer, test_version:"6.2.1.4252")){
  security_hole(0);
}
