###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_js_dos_vuln_sep09_win.nasl 4684 2009-09-11 13:54:33Z sep $
#
# Mozilla Firefox 'JavaScript' DoS Vulnerabilities - Sep09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900845);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3071", "CVE-2009-3075");
  script_bugtraq_id(36343);
  script_name("Mozilla Firefox 'JavaScript' DoS Vulnerabilities - Sep09 (Win)");
  desc = "
  Overview: The host is installed with Firefox browser and is prone to Denial
  of Service vulnerabilities.

  Vulnerability Insight:
  The flaws are due to multiple errors in the browser and JavaScript engines
  can be exploited to corrupt memory.

  Impact:
  A remote, unauthenticated attacker could execute arbitrary code or cause a
  vulnerable application to crash.

  Impact Level: System/Application

  Affected Software/OS:
  Mozilla Firefox version prior to 3.0.14 and 3.5 before 3.5.2 on Windows.

  Fix: Upgrade to Firefox version 3.0.14 or 3.5.2 or later
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/advisories/36671/
  http://www.vupen.com/english/advisories/2009/2585
  http://www.mozilla.org/security/announce/2009/mfsa2009-47.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer)
{
  exit(0);
}

# Grep for Firefox version < 3.0.14 and 3.5 < 3.5.2
if(version_is_less(version:ffVer, test_version:"3.0.14") ||
   version_in_range(version:ffVer,test_version:"3.5", test_version2:"3.5.1")){
  security_warning(0);
}
