###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_mult_dos_vuln_sep09_lin.nasl 4684 2009-09-11 15:42:33Z sep $
#
# Mozilla Firefox Multiple Denial Of Service Vulnerabilities - Sep09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900848);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3070", "CVE-2009-3074", "CVE-2009-3076");
  script_bugtraq_id(36343);
  script_name("Mozilla Firefox Multiple Denial Of Service Vulnerabilities - Sep09 (Linux)");
  desc = "
  Overview: The host is installed with Firefox browser and is prone to multiple
  Denial of Service vulnerabilities.

  Vulnerability Insight:
  - Multiple errors in the browser and JavaScript engines can be exploited
    to corrupt memory.
  - The warning dialog displayed when adding or removing security modules
    via 'pkcs11.addmodule' or 'pkcs11.deletemodule' does not contain enough
    information. This can be exploited to potentially trick a user into
    installing a malicious PKCS11 module.

  Impact:
  A remote, unauthenticated attacker could execute arbitrary code or cause
  a vulnerable application to crash.

  Impact Level: System/Application

  Affected Software/OS:
  Mozilla Firefox version prior to 3.0.14 on Linux.

  Fix: Upgrade to Firefox version 3.0.14 or later
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/advisories/36671/
  http://www.mozilla.org/security/announce/2009/mfsa2009-47.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-48.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer)
{
  exit(0);
}

# Grep for Firefox version < 3.0.14
if(version_is_less(version:ffVer, test_version:"3.0.14")){
  security_hole(0);
}
