###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_status_bar_spoof_vuln_lin.nasl 892 2009-01-27 15:05:33Z jan $
#
# Firefox Status Bar Spoofing Vulnerability (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900447);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0253");
  script_name("Firefox Status Bar Spoofing Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to status bar spoofing vulnerability.

  Vulnerability Insight:
  Firefox doesn't properly handle the crafted URL which is being displayed in
  the user's browser which lets the attacker perform clickjacking attack and
  can spoof the user redirect to a different arbitrary malformed website.

  Impact: Successful remote exploitation will let the attacker spoof the status
  bar information and can gain sensitive information by redirecting the
  authentic user to any malicious URL.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Firefox version 3.0.5 and 2.0.0.18/19 on Linux.

  Fix: No solution or patch is available as on 28th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.getfirefox.com

  References:
  http://www.milw0rm.com/exploits/7842
  http://security-tracker.debian.net/tracker/CVE-2009-0253

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Mozilla Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


firefoxVer = get_kb_item("Firefox/Linux/Ver");
#Check for firefox version 3.0.5 or 2.0.0.18/2.0.0.19
if(firefoxVer =~ "(2.0.0.18|2.0.0.19|3.0.5)"){
  security_hole(0);
}
