###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_freeradius_tunnel_password_dos_vuln.nasl 4617 2009-09-22 21:27:24Z sep $
#
# FreeRADIUS Tunnel-Password Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Updated By:
# Antu Sanadi <santu@secpod.com> on 2009/12/31 #6502
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900856);
  script_version("$Revision: 6302 $: 1.0");
  script_cve_id("CVE-2009-3111", "CVE-2009-4481");
  script_bugtraq_id(36263);
  script_name("FreeRADIUS Tunnel-Password Denial Of Service Vulnerability");
  desc = "
  Overview: This host is running FreeRADIUS and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaws are due to:
  - An error in the 'rad_decode()' function in 'src/lib/radius.c' which can
    be exploited via zero-length Tunnel-Password attributes.
  - An unspecified error that can be exploited to crash the 'radiusd' daemon.

  Impact:
  Successful exploitation will let the attacker to crash the service.

  Impact Level: Application

  Affected Software/OS:
  FreeRADIUS version prior to 1.1.8

  Fix: Upgrade to version 1.1.8
  http://freeradius.org/download.html
  or
  Apply patch from below link,
  http://github.com/alandekok/freeradius-server/commit/860cad9e02ba344edb0038419e415fe05a9a01f4

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/36509
  http://www.intevydis.com/blog/?p=66
  http://www.openwall.com/lists/oss-security/2009/09/09/1
  http://www.braindeadprojects.com/blog/what/freeradius-packet-of-death/
  https://lists.freeradius.org/pipermail/freeradius-users/2009-September/msg00242.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of FreeRADIUS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_freeradius_detect.nasl");
  script_require_keys("FreeRADIUS/Ver");
  exit(0);
}


include("version_func.inc");

foreach radius_port (make_list(1812, 1813, 1814))
{
  if(get_udp_port_state(radius_port))
  {
    freeradiusVer = get_kb_item("FreeRADIUS/Ver");
    if(freeradiusVer)
    {
      # Check for FreeRADIUS version < 1.1.8
      if(version_is_less(version:freeradiusVer, test_version:"1.1.8")){
        security_warning(port:radius_port, proto:"udp");
      }
    }
    exit(0);
  }
}
