###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_g15daemon_unspecified_vuln.nasl 4731 2009-09-17 18:48:24Z sep $
#
# G15Daemon Unspecified Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900854);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7197");
  script_name("G15Daemon Unspecified Vulnerability");
  desc = "
  Overview: This host has G15Daemon installed and is prone to Unspecified
  vulnerability.

  Vulnerability Insight:
  Multiple unspecified vulnerabilities exist, details are not available.

  Impact:
  Unknown impact.

  Impact Level: Application

  Affected Software/OS:
  G15Daemon version prior to 1.9.4

  Fix: Upgrade to version 1.9.4 or latest
  http://g15daemon.sourceforge.net/

  References:
  http://osvdb.org/40528
  http://archives.neohapsis.com/archives/apps/freshmeat/2008-01/0019.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of G15Daemon");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_g15daemon_detect.nasl");
  script_require_keys("G15Daemon/Ver");
  exit(0);
}


include("version_func.inc");

g15dVer = get_kb_item("G15Daemon/Ver");
if(!g15dVer) {
  exit(0);
}

# Check for G15Daemon version < 1.9.4
if(version_is_less(version:g15dVer, test_version:"1.9.4")){
  security_hole(0);
}
