###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_geccbblite_mult_xss_vuln.nasl 7391 2010-02-24 11:43:17Z feb $
#
# geccBBlite Multiple Cross-Site Scripting Vulnerabilities
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900747);
  script_version("$Revision: 6841 $: 1.0");
  script_cve_id("CVE-2009-4649");
  script_bugtraq_id(35449);
  script_name("geccBBlite Multiple Cross-Site Scripting Vulnerabilities");
  desc = "
  Overview: The host is running geccBBlite and is prone to multiple Cross-Site
  Scripting vulnerabilities.

  Vulnerability Insight:
  Flaws are caused by improper validation of user-supplied input in multiple
  scripts. This can be exploited using the 'postatoda' parameter to inject
  malicious script into a Web page.

  Impact:
  Successful exploitation will allow remote attackers to inject arbitrary web
  script or HTML in a user's browser session in the context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  geccBBlite version 0.1 and prior

  Fix: No solution or patch is available as on 24th February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/geccnuke/

  References:
  http://xforce.iss.net/xforce/xfdb/56278
  http://groups.csail.mit.edu/pag/ardilla/

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.9
  Risk factor : Medium";

  script_description(desc);
  script_copyright("Copyright (C) 2010 SecPod");
  script_summary("Check through version of geccBBlite");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_dependencies("secpod_geccbblite_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

gbbPort = get_http_port(default:80);
if(!gbbPort){
  exit(0);
}

gcbbVer = get_kb_item("www/" + gbbPort + "/geccBBlite");
if(isnull(gcbbVer)){
  exit(0);
}

gcbbVer = eregmatch(pattern:"^(.+) under (/.*)$", string:gcbbVer);
if(gcbbVer[1] != NULL)
{
  #Check for version is or equal to 0.1(1.0)
  if(version_is_equal(version:gcbbVer[1], test_version:"1.0")){
    security_warning(gbbPort);
  }
}
