###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_google_chrome_info_dis_vuln.nasl 878 2009-01-21 12:00:29Z jan $
#
# Google Chrome Information Disclosure Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900439);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5915");
  script_bugtraq_id(33276);
  script_name("Google Chrome Information Disclosure Vulnerability");
  desc = "

  Overview: This host is installed with Google Chrome and is prone to
  information disclosure vulnerability.

  Vulnerability Insight:
  This flaw is due to cross-domain information disclosure vulnerability as
  the web browser fails to properly enforce the same-origin policy.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in
  the context of the web browser and can reveal sensitive information of the
  remote user through the web browser.

  Affected Software/OS:
  Google Chrome version 1.0.154.43 and prior.

  Fix: No solution or patch is available as on 22nd January 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://googlechromereleases.blogspot.com

  References:
  http://www.trusteer.com/files/In-session-phishing-advisory-2.pdf
  http://www.darkreading.com/security/attacks/showArticle.jhtml?articleID=212900161

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

if(version_is_less_equal(version:chromeVer, test_version:"1.0.154.43")){
  security_hole(0);
}
