###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_keygen_dos_vuln.nasl 4892 2009-09-22 18:35:29Z sep $
#
# Google Chrome 'KEYGEN' Element Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900862);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3268");
  script_name("Google Chrome 'KEYGEN' Element Denial Of Service Vulnerability");
  desc = "
  Overview: This host is installed with Google Chrome and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  Error exists via KEYGEN element in conjunction with a META element specifying
  automatic page refresh or a JavaScript onLoad event handler for a BODY element.

  Impact:
  Successful exploitation will let the remote attackers to cause Denial of
  Service on the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version 1.0.154.48 and prior on Windows.

  Fix: No solution or patch is available as on 22nd september 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.google.com/chrome

  References:
  http://websecurity.com.ua/3194/
  http://www.securityfocus.com/archive/1/archive/1/506328/100/100/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version <= 1.0.154.48
if(version_is_less_equal(version:chromeVer, test_version:"1.0.154.48")){
  security_warning(0);
}
