##############################################################################
#
#  hMailServer IMAP Denial of Service Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/18
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0119
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900109);
 script_bugtraq_id(30663);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("hMailServer IMAP Denial of Service Vulnerability");
 script_summary("Check for vulnerable version of hMailServer");
 desc = "
 Overview : This host is running hMailServer, which is prone to
 Denial of Service vulnerability.

 Vulnerability Insight :
	
        The flaw is due to an error in the mail server that can be exploited 
        by sending large numbers of IMAP commands.

        Impact : Exploitation will cause the server to crash and deny access
        to legitimate users.

 Impact Level : Application/System

 Affected Software/OS :
        hMailServer version 4.4.1 - Build 273 and prior

 Fix :  Fixed in development version 4.4.2 (build 279)
 http://www.hmailserver.com/?page=download_mirrors&downloadid=144

 References :
 http://www.securityfocus.com/archive/1/495361
 http://secunia.com/advisories/31480/

 CVSS Score :
        CVSS Base Score     : 6.3 (AV:N/AC:M/Au:SI/C:N/I:N/A:C)
        CVSS Temporal Score : 4.9
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("imap_func.inc");
 
 port = get_kb_item("Services/imap");
 if(!port) {
	port = 143;
 }

 if(!get_port_state(port)) {
	exit(0);
 }

 if("IMAP" >!< get_imap_banner(port:port)){
        exit(0);
 }

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 hmsVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion"
					+ "\Uninstall\hMailServer_is1",
			  item:"DisplayName");
 if(!hmsVer){
	exit(0);
 } 

 if(egrep(pattern:"hMailServer ([0-3]\..*|4\.([0-3]\..*|4\.[01]))", string:hmsVer)){
	security_warning(port);
 }
