###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ibm_db2_mult_dos_vuln_lin02.nasl 2649 2009-06-23 15:11:27Z jun $
#
# IBM DB2 Multiple Vulnerabilities (Linux)
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Updated KB Name
# Antu Sanadi <santu@secpod.com> on 2009-12-21
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900679);
  script_version("$Revision: 6248 $: 1.1");
  script_cve_id("CVE-2008-6821", "CVE-2008-6820", "CVE-2008-2154");
  script_bugtraq_id(31058, 35409);
  script_name("IBM DB2 Multiple Vulnerabilities (Linux)");
  desc = "

  Overview: The host is installed with IBM DB2 and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The flaws is caused due to,
  - An unspecified error related to the DB2FMP process running
    with OS prvileges.
  - An error in INSTALL_JAR procedure might allow remote authenticated
    users to create or overwrite arbitrary files via unspecified calls.
  - A boundary error in DAS server code can be exploited to cause a buffer
    overflow via unspecified vectors.

  Impact:
  Successful exploitation will let the attacker to bypass security restrictions,
  cause a denial of service or gain elevated privileges.

  Impact Level: System/Application

  Affected Software/OS:
  IBM DB2 version 8 prior to Fixpak 17
  IBM DB2 version 9.1 prior to Fixpak 5
  IBM DB2 version 9.5 prior to Fixpak 2

  Fix:Update DB2 8 Fixpak 17 or 9.1 Fixpak 5 or 9.5 Fixpak 2 or later.
  http://www-01.ibm.com/support/docview.wss?rs=0&uid=swg24022678


  References:
  http://secunia.com/advisories/31787
  http://securitytracker.com/alerts/2009/Jun/1022319.htm
  http://www-01.ibm.com/support/docview.wss?uid=swg1JR30227
  ttp://www-01.ibm.com/support/docview.wss?uid=swg21318189


  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of IBM DB2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_ibm_db2_detect_linux_900217.nasl");
  script_require_keys("Linux/IBM_db2/Ver");
  exit(0);
}


include("version_func.inc");

ibmVer = get_kb_item("Linux/IBM_db2/Ver");
if(!ibmVer){
  exit(0);
}

# Check for IBM DB2 Products Version 8 before 8 FP17 (8.1.17)-8.1.17.617
# Check for IBM DB2 Products Version 9.1 before 9.1 FP5 (9.1.500)-9.1.0.5
# Check for IBM DB2 Products Version 9.5 before 9.5 FP2 => 9.5.0.2
# IBM DB2 9.1 FP4a =>9.1.0.4
# IBM DB2 9.5 FP1 =>9.5.0.1

if(version_in_range(version:ibmVer, test_version:"8.0", test_version2:"8.1.16") ||
   version_in_range(version:ibmVer, test_version:"9.1", test_version2:"9.1.0.4") ||
   version_in_range(version:ibmVer, test_version:"9.5", test_version2:"9.5.0.1")){
  security_hole(0);
}
