##############################################################################
#
#  IBM HTTP Server mod_proxy Interim Responses DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/23
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0122
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900222);
 script_bugtraq_id(29653);
 script_cve_id("CVE-2008-2364");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("IBM HTTP Server mod_proxy Interim Responses DoS Vulnerability");
 script_summary("Check for IBM HTTP Server version");
 desc = "
 Overview : This host is running IBM HTTP Server, which is prone to Denial of
 Service Vulnerability.

 Vulnerability Insight :

        Issue is caused due to an error in the ap_proxy_http_process_response()
        function in mod_proxy_http.c in the mod_proxy module when processing 
        large number of interim responses to the client, which could consume 
        all available memory resources.

        Impact : A remote/local user can cause denial of service 

 Impact Level : Application

 Affected Software/OS :
        IBM HTTP Server versions prior to 6.1.0.19. 

 Fix : Update to Fix Pack 19 
 http://www-01.ibm.com/support/docview.wss?uid=swg27008517

 *****
 NOTE : Ignore this warning if above mentioned patch is applied already.
 *****

 References :
 http://secunia.com/Advisories/31904/
 http://xforce.iss.net/xforce/xfdb/42987
 http://www-01.ibm.com/support/docview.wss?rs=177&context=SSEQTJ&uid=swg21173021

 CVSS Score :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.3
 Risk factor : High";

 script_description(desc);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80, 8880, 8008);
 exit(0);
}


 include("http_func.inc");

 ports = make_list("80","8008","8880");

 foreach port (ports)
 {
        ibmWebSer = get_http_banner(port);
 
        # Check for IBM HTTP Server Version
        if(egrep(pattern:"Server: IBM_HTTP_Server.*", string:ibmWebSer))
        {
                if(egrep(pattern:"IBM_HTTP_Server/([0-5]\..*|6\.[01])[^.0-9]",
                         string:ibmWebSer))
		{
                        security_hole(port);
			exit(0);
		}
        }
 }
