###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ipsec-tools_memory_leakage_vuln.nasl 2322 2009-05-15 11:15:29Z may $
#
# IPSec-Tools Memory Leakage Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900708);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1632");
  script_name("IPSec-Tools Memory Leakage Vulnerability");
  desc = "

  Overview: This host is installed with IPSec-Tools for Linux and is prone
  to Memory Leakage Vulnerability.

  Vulnerability Insight:
  Multiple memory leaks are cause due to error in eay_check_x509sign function in
  'src/racoon/crypto_openssl.c' and NAT Traversal keepalive implementation in
  'src/racoon/nattraversal.c' files.

  Impact:
  Successful exploitation will let the attacker cause multiple memory leaks or
  memory consumption through signature verification during user authentication
  with X.509 certificates.

  Impact level: System/Application

  Affected Software/OS:
  IPsec Tools version prior to 0.7.2

  Fix:
  Upgrade to the latest version 0.7.2
  http://ipsec-tools.sourceforge.net

  References:
  https://trac.ipsec-tools.net/ticket/303
  http://www.openwall.com/lists/oss-security/2009/05/12/3
  http://sourceforge.net/project/shownotes.php?group_id=74601&release_id=677611

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of IPSec-Tools");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_ipsec-tools_detect.nasl");
  script_require_keys("IPSec/Tools/Ver");
  exit(0);
}


include("version_func.inc");

ipsecVer = get_kb_item("IPSec/Tools/Ver");
if(ipsecVer == NULL){
  exit(0);
}

# Grep for IPSec-Tools version prior to 0.7.2
if(version_is_less(version:ipsecVer, test_version:"0.7.2")){
  security_hole(0);
}
