#################################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_java_jre_actvx_ctrl_mult_bof_vuln.nasl 2379 2009-05-19 17:35:41Z may $
#
# Java JRE deploytk.dll ActiveX Control Multiple BOF Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#################################################################################

if(description)
{
  script_id(900354);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1671", "CVE-2009-1672");
  script_bugtraq_id(34931);
  script_name("Java JRE deploytk.dll ActiveX Control Multiple BOF Vulnerabilities");
  desc = "

  Overview: This host is installed with Java JRE Deployment Toolkit ActiveX and
  is prone to multiple buffer overflow vulnerabilities.

  Vulnerability Insight:
  Multiple buffer overflow are caused due to,
  - error in deploytk.dll file control while processing the setInstallerType,
    setAdditionalPackages, compareVersion, getStaticCLSID and launch method.
  - error in installLatestJRE or installJRE method in deploytk.dll control and
    it can allow attacker to launch JRE installation processes.
  - error in launch method can cause script code execution via a .jnlp URL.

  Impact:
  Attacker may exploit this issue to launch JRE installation and execute
  arbitrary script code on the victim's system, and can deny the service.

  Impact Level: System/Application

  Affected Software/OS:
  Sun Java JRE version 6 Update 1 to 6 Update 13 and prior
  Sun Microsystems, deploytk.dll version 6.0.130.3 and prior

  Fix: No solution or patch is available as on 21st May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://java.sun.com

  Workaround:
  Set the killbit for the CLSID {CAFEEFAC-DEC7-0000-0000-ABCDEFFEDCBA}
  http://support.microsoft.com/kb/240797

  References:
  http://www.milw0rm.com/exploits/8665
  http://www.shinnai.net/xplits/TXT_mhxRKrtrPLyAHRFNm7QR.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of deploytk.dll and JAVA JRE");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl", "gb_java_prdts_detect_win.nasl");
  script_require_keys("SMB/WindowsVersion", "Sun/Java/JRE/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");


jreVer = get_kb_item("Sun/Java/JRE/Win/Ver");
if(!jreVer){
  exit(0);
}

jreVer = ereg_replace(pattern:"_", string:jreVer, replace: ".");
if(version_in_range(version:jreVer, test_version:"1.6.0", test_version2:"1.6.0.13"))
{
  dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(!dllPath){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                       string:dllPath + "\deploytk.dll");

  dllVer = GetVer(file:file, share:share);
  if(!dllVer){
    exit(0);
  }

  # Check for version of deploytk.dll
  if(version_is_less_equal(version:dllVer, test_version:"6.0.130.3"))
  {
    if(is_killbit_set(clsid:"{CAFEEFAC-DEC7-0000-0000-ABCDEFFEDCBA}") == 0){
      security_hole(0);
    }
  }
}
