##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_jaws_cms_dir_traversal_vuln.nasl 1041 2009-02-20 11:15:29Z feb $
#
# Jaws CMS Directory Traversal Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900460);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(33607);
  script_cve_id("CVE-2009-0645");
  script_name("Jaws CMS Directory Traversal Vulnerability");
  desc = "

  Overview: This host is running Jaws CMS and is prone to Directory
  Traversal Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to error in file 'index.php' in 'language'
  parameter which lets the attacker execute local file inclusion attacks.

  Impact:
  Successful exploitation will let the attacker execute local file inclusion
  attacks and gain sensitive information about the remote system directories
  where Jaws CMS runs.

  Impact level: Application/System

  Affected Software/OS:
  Jaws CMS 0.8.8 and prior

  Fix:
  Upgrade to the latest version 0.8.9
  http://www.jaws-project.com

  References:
  http://www.milw0rm.com/exploits/7976
  http://xforce.iss.net/xforce/xfdb/48476

  CVSS Score:
    CVSS Base Score     : 6.5 (AV:N/AC:L/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 5.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for version of Jaws CMS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  script_dependencies("http_version.nasl");
  exit(0);
}


include("version_func.inc");
include("http_func.inc");
include("http_keepalive.inc");

jawsPort = get_kb_item("Services/www");
if(!get_port_state(jawsPort)){
  exit(0);
}

foreach path(make_list("/", cgi_dirs()))
{
  request = http_get(item:"/jaws/index.php", port:jawsPort);
  response = http_keepalive_send_recv(port:jawsPort, data:request);
  if(response == NULL){
    exit(0);
  }
  if("Jaws" >< response)
  {
    version = eregmatch(pattern:"Jaws ([0-9.]+)", string:response);
    if(version[1] != NULL)
    {
      if(version_is_less_equal(version:version[1], test_version:"0.8.8"))
      {
        security_hole(jawsPort);
        exit(0);
      }
    }
    exit(0);
  }
}
exit(0);
