###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_kde_konqueror_select_dos_vuln.nasl 3576 2009-07-30 10:24:48Z jul $
#
# KDE Konqueror Select Object Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900903);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-2537");
  script_name("KDE Konqueror Select Object Denial of Service Vulnerability");
  desc = "

  Overview: This host is installed with KDE Konqueror and is prone to Denial 
  of Service Vulnerability.

  Vulnerability Insight:
  The flaw occurs due to an error while processing Select object whose length
  property contains a large integer value.

  Impact:
  Successful exploitation will lead to memory consumption and can result in
  a browser crash.

  Affected Software/OS:
  KDE Konqueror version 4.2.4 and prior.

  Fix:
  No solution or patch is available as on as on 30th July 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.kde.org/download

  References:
  http://www.milw0rm.com/exploits/9160
  http://www.g-sec.lu/one-bug-to-rule-them-all.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Konqueror");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_kde_konqueror_detect.nasl");
  script_require_keys("KDE/Konqueror/Ver");
  exit(0);
}


include("version_func.inc");

konqerVer = get_kb_item("KDE/Konqueror/Ver");

if(konqerVer != NULL)
{
  # Grep for version 4.2.4  or prior
  if(version_is_less_equal(version:konqerVer, test_version:"4.2.4")){
    security_warning(0);
  }
}
