###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_media_player_classic_detect.nasl 4800 2009-09-17 13:21:29Z sep $
#
# Gabset Media Player Classic Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900947);
  script_version("$Revision: 1.0 $");
  script_name("Gabset Media Player Classic Version Detection");
  desc = "
  Overview: This script detects the installed version of Gabset Media Player
  Classic and sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Media Player Classic");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")) {
  exit(0);
}

mpcPath = registry_get_sz(key:"SOFTWARE\Gabest\Media Player Classic",
                          item:"ExePath");
if(mpcPath != NULL)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:mpcPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:mpcPath);

  mpcVer = GetVer(file:file, share:share);
  if(mpcVer != NULL){
    set_kb_item(name:"MediaPlayerClassic/Ver", value:mpcVer);
  }
}
