##############################################################################
#
#  Microsoft Office Filters Could Allow Remote Code Execution Vulnerabilities (924090)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/13
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0111
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900029);
 script_bugtraq_id(30598, 30595, 30597, 30599, 30600);
 script_cve_id("CVE-2008-3018", "CVE-2008-3019", "CVE-2008-3020",
	       "CVE-2008-3021", "CVE-2008-3460");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Windows : Microsoft Bulletins");
 script_name("Microsoft Office Filters Could Allow Remote Code Execution Vulnerabilities (924090)");
 script_summary("Check for file version");
 desc = "
 Overview : This host is missing critical security update according to
 Microsoft Bulletin MS08-044.

 Vulnerability Insight :

        Multiple flaws due to memory corruption errors when processing
        specially crafted Encapsulated PostScript (EPS) files, and PICT,
        BMP, or WordPerfect Graphics (WPG) images.

        Impact : Remote exploitation could allow attackers to execute
        arbitrary code by tricking a user into opening a malicious office
        file, and also can crash an affected application.

 Impact Level : System

 Affected Software/OS :
        Microsoft Office 2k SP3 on Windows (All).
        Microsoft Office XP Service Pack 3 on Windows (All).
        Microsoft Office 2003 Service Pack 2 on Windows (All).
        Microsoft Office Project 2002 Service Pack 1 on Windows (All).

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link.
 http://www.microsoft.com/technet/security/bulletin/ms08-044.mspx

 References : http://www.microsoft.com/technet/security/bulletin/ms08-044.mspx

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.1 
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl", "secpod_ms_office_detection_900025.nasl");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_reg.inc");
 include("secpod_smb_func.inc");

 if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
        exit(0);
 }

 function Get_FileVersion()
 {
	gifPath = registry_get_sz(item:"Path",
           	  key:"SOFTWARE\Microsoft\Shared Tools\Graphics Filters\Export\GIF");

        if(!gifPath){
                exit(0);
        }

        share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:gifPath);
        file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:gifPath);

        name    =  kb_smb_name();
        login   =  kb_smb_login();
        pass    =  kb_smb_password();
        domain  =  kb_smb_domain();
        port    =  kb_smb_transport();

        soc = open_sock_tcp(port);
        if(!soc){
                exit(0);
        }

        r = smb_session_request(soc:soc, remote:name);
        if(!r)
        {
                close(soc);
                exit(0);
        }

        prot = smb_neg_prot(soc:soc);
        if(!prot)
        {
                close(soc);
                exit(0);
        }

        r = smb_session_setup(soc:soc, login:login, password:pass,
                              domain:domain, prot:prot);
        if(!r)
        {
                close(soc);
                exit(0);
        }

        uid = session_extract_uid(reply:r);

        r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
        tid = tconx_extract_tid(reply:r);
        if(!tid)
        {
                close(soc);
                exit(0);
        }

        fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
        if(!fid)
        {
                close(soc);
                exit(0);
        }

	v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod", offset:16500);
	return v;
 }

 if(!get_kb_item("MS/Office/Ver")){
	exit(0);
 }

 gifVer = Get_FileVersion();
 if(!gifVer){
	exit(0);
 }

 #Grep for Gifimp32.flt version < 2003.1100.8165
 if(egrep(pattern:"^([01]?[0-9]?[0-9]?[0-9]\..*|200[0-2]\..*|2003\.([0-9]?[0-9]?" +
		  "[0-9]\..*|10[0-9][0-9]\..*|1100\.([0-7]?[0-9]?[0-9]?[0-9]|80" +
		  "[0-9][0-9]|81[0-5][0-9]|816[0-4])))$",
	  string:gifVer)){
	security_hole(0);
 }
