##############################################################################
#
#  Message Queuing Remote Code Execution Vulnerability (951071)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.0
#
#  Log: veerendragg
#  Issue #0328
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900224);
  script_bugtraq_id(31637);
  script_cve_id("CVE-2008-3479");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Windows : Microsoft Bulletins");
  script_name("Message Queuing Remote Code Execution Vulnerability (951071)");
  script_summary("Check for the Hotfix and version of Message Queue component");
  desc = "
  MS08-065

  Overview: This host is missing important security update according to
  Microsoft Bulletin MS08-065.

  Vulnerability Insight:
  The flaw exists due to a boundary error when parsing RPC requests to the
  Message Queuing (MSMQ).

  Impact: Successful exploitation could allow remote code execution by
  sending a specially crafted RPC request and can take complete control
  of an affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2000 Service Pack 4 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/Bulletin/MS08-065.mspx

  References: http://www.microsoft.com/technet/security/Bulletin/MS08-065.mspx

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5) <= 0){
  exit(0);
}

msmqIns = registry_get_sz(key:"SOFTWARE\Microsoft\MSMQ\Parameters",
                          item:"CurrentBuild");
if(!msmqIns){
  exit(0);
}

# Check for Hotfix 951071 (MS08-065).
if(hotfix_missing(name:"951071") == 0){
  exit(0);
}

# Get System32 Path
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

exePath = sysPath + "\Mqsvc.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

fileVer = GetVer(file:file, share:share);
if(fileVer == NULL){
  exit(0);
}

# Grep Mqsvc.exe version < 5.0.0.807
if(egrep(pattern:"^(5\.0\.0\.([0-7]?[0-9]?[0-9]|80[0-6]))$",
           string:fileVer)){
  security_warning(0);
}
