###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms08-077.nasl 657 2008-12-11 14:53:39Z dec $
#
# Vulnerability in Microsoft Office SharePoint Server Could Cause Elevation of Privilege (957175)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright: SecPod
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900064);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4032");
  script_bugtraq_id(32638);
  script_name("Vulnerability in Microsoft Office SharePoint Server Could Cause Elevation of Privilege (957175)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-077.

  Vulnerability Insight:
  The flaw is caused due to SharePoint Server does not properly restrict
  access to administrative portions of the application.

  Impact:
  Successful attack result in bypassing certain security restrictions by using
  web browser to directly access the vulnerable administrative functionality.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Search Server 2008
  Microsoft Office SharePoint Server

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-077.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms08-077.mspx

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 4.7
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2003:3) <= 0){
  exit(0);
}

# Hotfix 956716 (MS08-077)
if(hotfix_missing(name:"956716") == 0){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  appName = registry_get_sz(item:"DisplayName", key:key + item);
  if(("Microsoft Office SharePoint Server 2007" >< appName)||
     ("Microsoft Search Server 2008" >< appName))
  {
    dllPath = registry_get_sz(key:key + item, item:"InstallLocation");
    if(!dllPath){
      exit(0);
    }

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
    file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                         string:dllPath + "\12.0\Bin\Mssearch.exe");

    dllVer = GetVer(file:file, share:share);
    if(dllVer != NULL)
    {
      if(version_is_less(version:dllVer, test_version:"12.0.6318.5000")){
        security_warning(0);
      }
      exit(0);
    }
  }
}
