###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-005.nasl 1018 2009-02-11 17:26:22Z feb $
#
# Vulnerabilities in Microsoft Office Visio Could Allow Remote Code Execution (957634)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900080);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0095", "CVE-2009-0096", "CVE-2009-0097");
  script_bugtraq_id(33659, 33660, 33661);
  script_name("Vulnerabilities in Microsoft Office Visio Could Allow Remote Code Execution (957634)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-005.

  Vulnerability Insight:
  - Error exists when parsing object data during opening of Visio files.
  - Pop-Up error while copying object data in memory.
  - Error while handling of memory when opening Visio files.

  Impact:
  Successful exploitation could lead to memory corruption by sending
  a specially crafted Visio file.

  Impact Level: System

  Affected Software/OS:
  Microsoft Office Visio 2002/2003/2007 on Windows

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-005.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-005.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

ovPath = registry_get_sz(item:"Path",
         key:"SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\visio.exe");

if(!ovPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ovPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:ovPath + "visio.exe");

exeVer = GetVer(file:file, share:share);
if(!exeVer){
  exit(0);
}

# Check for visio.exe version for 2002, 2003 and 2007
if(version_is_less(version:exeVer, test_version:"10.0.6885.4")||
   version_is_less(version:exeVer, test_version:"11.0.8207.0")||
   version_is_less(version:exeVer, test_version:"12.0.6325.5000")){
  security_hole(0);
}
