###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-015.nasl 1696 2009-04-15 09:16:04Z apr $
#
# Blended Threat Vulnerability in SearchPath Could Allow Elevation of Privilege (959426)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900533);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-2540");
  script_bugtraq_id(29445);
  script_name("Blended Threat Vulnerability in SearchPath Could Allow Elevation of Privilege (959426)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-015.

  Vulnerability Insight:
  The flaw is caused due to an error in the way SearchPath function in
  Windows locates and opens files on the system.

  Impact:
  Remote attackers could execute arbitrary code by convincing a user to
  download a crafted file to a specific location, and then open an
  application that loads the file.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-015.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-015.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable File Version and Hotfix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 959426 (MS09-015).
if(hotfix_missing(name:"959426") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\secur32.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for secur32.dll version < 5.0.2195.7244
  if(version_is_less(version:dllVer, test_version:"5.0.2195.7244")){
    security_hole(0);
  }
  exit(0);
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for secur32.dll version < 5.1.2600.3518
    if(version_is_less(version:dllVer, test_version:"5.1.2600.3518")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for secur32.dll version < 5.1.2600.5753
    if(version_is_less(version:dllVer, test_version:"5.1.2600.5753")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Check for secur32.dll version < 5.2.3790.3290
    if(version_is_less(version:dllVer, test_version:"5.2.3790.3290")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Check for secur32.dll version < 5.2.3790.4455
    if(version_is_less(version:dllVer, test_version:"5.2.3790.4455")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
