###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-023.nasl 2777 2009-06-10 13:32:45Z jun $
#
# Microsoft Windows Search Script Execution Vulnerability (963093)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900568);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0239");
  script_bugtraq_id(35220);
  script_name("Microsoft Windows Search Script Execution Vulnerability (963093)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-023.

  Vulnerability Insight:
  The flaw is caused because the search function does not properly restrict the
  environment within which scripts execute, which could allow sensitive
  information disclosure.

  Impact:
  Remote attackers could exploit this issue to obtain sensitive information
  or access to data on the affected system by convincing a user to download
  a crafted file to a specific location, and then open an application that
  loads the file.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-023.mspx

  References:
  http://secunia.com/advisories/35366
  http://support.microsoft.com/kb/963093
  http://www.microsoft.com/technet/security/bulletin/ms09-023.mspx

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the vulnerable File Version and Hotfix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2003:3) <= 0){
  exit(0);
}

# Windows Search 4.0 is required
searchName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\Uninstall\KB940157", item:"DisplayName");
if(searchName >!< "Windows Search 4.0" && searchName == NULL){
  exit(0);
}

# Check for Hotfix 963093 (MS09-023).
if(hotfix_missing(name:"963093") == 0){
  exit(0);
}

exePath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
if(!exePath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:exePath + "\Spupdsvc.exe");

exeVer = GetVer(file:file, share:share);
if(!exeVer){
  exit(0);
}

# Check for Spupdsvc.exe < 6.3.15.0
if(version_is_less(version:exeVer, test_version:"6.3.15.0")){
  security_warning(0);
}
