###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-026.nasl 2774 2009-06-10 09:14:35Z jun $
#
# Vulnerability in RPC Could Allow Elevation of Privilege (970238)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900668);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0568");
  script_name("Vulnerability in RPC Could Allow Elevation of Privilege (970238)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-026.

  Vulnerability Insight:
  The flaws occurs because the Remote Procedure Call (RPC) Marshalling Engine
  does not updating its internal state in an appropriate manner.

  Impact:
  Successful exploitation could allow remote or local attackers to execute
  arbitrary code by sending specially crafted RPC message to a vulnerable
  third-party RPC application

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-026.mspx

  References:
  http://www.vupen.com/english/advisories/2009/1545
  http://www.microsoft.com/technet/security/bulletin/ms09-026.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check Hotfix Missing 970238 (MS09-026)
if(hotfix_missing(name:"970238") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Rpcrt4.dll");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Rpcrt4.dll  version < 5.0.2195.7281
    if(version_is_less(version:sysVer, test_version:"5.0.2195.7281")){
      security_hole(0);
  }
  exit(0);
}

# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Rpcrt4.dll < 5.1.2600.3555
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3555")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Rpcrt4.dll < 5.1.2600.5795
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5795")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Rpcrt4.dll version < 5.2.3790.4502
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4502")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
