###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms10-013.nasl 7180 2010-02-10 09:14:35Z feb $
#
# Microsoft DirectShow Remote Code Execution Vulnerability (977935)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902117);
  script_version("$Revision: 6706 $:1.0");
  script_cve_id("CVE-2010-0250");
  script_bugtraq_id(38112);
  script_name("Microsoft DirectShow Remote Code Execution Vulnerability (977935)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS10-013.

  Vulnerability Insight:
  The flaw is caused by a heap overflow error in the Microsoft DirectShow
  component when handling malformed AVI files.

  Impact:
  Successful exploitation could allow remote attackers to crash an affected
  system or execute arbitrary code by tricking a user into visiting a specially
  crafted web page.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2000 Service Pack 4 and prior
  Microsoft Windows XP Service Pack 3 and prior
  Microsoft Windows 2003 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms10-013.mspx

  References:
  http://www.vupen.com/english/advisories/2010/0346
  http://www.microsoft.com/technet/security/bulletin/ms10-013.mspx

  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

function Get_dllversion(path, dllfile)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:path + dllfile);
  sysVer = GetVer(file:file, share:share);
  if(isnull(sysVer)){
    return 0;
  }
  else
    return sysVer;
}

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for MS10-013 Hotfixes 977914, 975560
if((hotfix_missing(name:"977914") == 0) && (hotfix_missing(name:"975560") == 0)){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

sysVer1 =  Get_dllversion(path:sysPath, dllfile:"\Avifil32.dll");
sysVer2 =  Get_dllversion(path:sysPath, dllfile:"\Quartz.dll");

if(!(sysVer1 && sysVer2)){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Avifil32.dll version < 5.0.2195.7359, Quartz.dll < 6.5.1.913, 6.1.9.738
  if(version_is_less(version:sysVer1, test_version:"5.0.2195.7359") ||
     version_in_range(version:sysVer2, test_version:"6.5", test_version:"6.5.1.912") ||
     version_in_range(version:sysVer2, test_version:"6.1", test_version:"6.1.9.737")) {
    security_hole(0);
  }
}

# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Avifil32.dll 5.1.2600.3649, Quartz.dll < 6.5.2600.3649
    if(version_is_less(version:sysVer1, test_version:"5.1.2600.3649") ||
       version_is_less(version:sysVer2, test_version:"6.5.2600.3649")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Avifil32.dll <  5.1.2600.5908, Quartz.dll < 6.5.2600.5908
    if(version_is_less(version:sysVer1, test_version:"5.1.2600.5908") ||
       version_is_less(version:sysVer2, test_version:"6.5.2600.5908")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Avifil32.dll <  5.2.3790.4625, Quartz.dll < 6.5.3790.4625
    if(version_is_less(version:sysVer1, test_version:"5.2.3790.4625") ||
       version_is_less(version:sysVer2, test_version:"6.5.3790.4625")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
