###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_directx_code_exec_vuln.nasl 1698 2009-06-01 11:27:04Z apr $
#
# Vulnerability in Microsoft DirectShow Could Allow Remote Code Execution
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900097);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1537");
  script_bugtraq_id(35139);
  script_name("Vulnerability in Microsoft DirectShow Could Allow Remote Code Execution");
  desc = "

  Overview: This host is installed with Microsoft DirectShow and is prone to
  remote code execution vulnerability.

  Vulnerability Insight:
  Microsoft DirectShow fails to handle supported QuickTime format files. This
  could allow code execution if a user opened a specially crafted QuickTime
  media file when a user is logged on with administrative user rights.

  Impact:
  Attacker who successfully exploit this flaw could take complete control of
  an affected system.

  Impact Level: System

  Affected Software/OS:
  DirectX 7.0 8.1 and 9.0* on Microsoft Windows 2K
  DirectX 9.0 on Microsoft Windows XP and 2K3

  Fix: No solution or patch is available as on 29th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,  http://www.microsoft.com

  Workaround: Apply workaround steps mentioned in the reference link.

  References: http://www.microsoft.com/technet/security/advisory/971778.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Directx");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod"); 
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

# OS with Hotfix Check
if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check DirectX is installed
directXver = registry_get_sz(key:"SOFTWARE\Microsoft\DirectX", item:"Version");
if(!directXver){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  if(directXver =~ "^4\.0[7-9]"){
      security_hole(0);
  }
}

else if(hotfix_check_sp(xp:4) > 0)
{
  if(directXver =~ "^4\.09"){
    security_hole(0);
  }
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  if(directXver =~ "^4\.09"){
    security_hole(0);
  }
}
