###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_xss_filter_xss_vuln_nov09.nasl 5912 2009-11-27 12:55:29Z nov $
#
# Microsoft Internet Explorer 'XSS Filter' XSS Vulnerabilities - Nov09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900898);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4074");
  script_bugtraq_id(37135);
  script_name("Microsoft Internet Explorer 'XSS Filter' XSS Vulnerabilities - Nov09");
  desc = "
  Overview: This host is installed with Internet Explorer and is prone to
  Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  The XSS Filter used in 'response-changing mechanism' to conduct XSS attacks
  against web sites that have no inherent XSS vulnerabilities, related to the
  details of output encoding.

  Impact:
  Successful exploitation will let the attackers to conduct cross-site scripting
  attacks on the affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Internet Explorer version 8 on Windows.

  Fix: No solution or patch is available as on 27th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/internet-explorer/default.aspx

  References:
  http://www.owasp.org/images/5/50/OWASP-Italy_Day_IV_Maone.pdf
  http://www.theregister.co.uk/2009/11/20/internet_explorer_security_flaw/
  http://hackademix.net/2009/11/21/ies-xss-filter-creates-xss-vulnerabilities/

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# Check for MS IE version 8
if(ieVer =~ "^8\..*"){
  security_warning(0);
}
