##############################################################################
#
#  Microsoft Windows Media Player 'MIDI' or 'DAT' File DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/05
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0437
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900172);
  script_bugtraq_id(32077);
  script_cve_id("CVE-2008-4927");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("Microsoft Windows Media Player 'MIDI' or 'DAT' File DoS Vulnerability");
  script_summary("Check for vulnerable version of Windows Media Player");
  desc = "
  Overview: This host is installed with Windows Media Player and is prone to
  denial of service vulnerability.

  The vulnerability is caused due to error in handling 'MIDI' or 'DAT' file,
  related to 'MThd Header Parsing'.

  Impact:
  Successful exploitation will cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Windows Media Player versions 9.x, 10.x and 11.x

  Fix: No solution/patch is available as on 05th November, 2008.

  References:
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-4927
  http://www.securityfocus.com/data/vulnerabilities/exploits/32077.py

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl",
                      "secpod_ms_win_media_player_detect_900173.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check the versions 9.x , 10.x and 11.x
if(get_kb_item("Win/MediaPlayer/Ver") =~ "^(9|1[01])\..*$"){
  security_warning(0);
}
