###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_win_xp_spi_dos_vuln.nasl 2535 2009-06-01 16:19:35Z jun $
#
# Windows XP 'SPI_GETDESKWALLPAPER' DoS Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# Updated to MS09-025 Bulletin
#   - By Sharath S <sharaths@secpod.com> On 2009-08-13
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900724);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-1808");
  script_bugtraq_id(35120);
  script_name("Windows XP 'SPI_GETDESKWALLPAPER' DoS Vulnerability");
  desc = "

  Overview: This host is running Windows XP operating system and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  Error exists while making an 'SPI_SETDESKWALLPAPER' SystemParametersInfo
  call with an improperly terminated 'pvParam' argument, followed by an
  'SPI_GETDESKWALLPAPER' SystemParametersInfo system calls.

  Impact:
  Successful exploitation will let the attacker execute the malicious code
  into the context of an affected operating system and cause crash in the
  operating system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows XP SP3 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-025.mspx

  References:
  http://www.ragestorm.net/blogs/?p=78

  CVSS Score:
    CVSS Base Score     : 4.9 (AV:L/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 4.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the existence of KB968537");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("secpod_reg.inc");

# Check Hotfix Missing  (MS09-025)
if(hotfix_missing(name:"968537") == 0){
  exit(0);
}

if(hotfix_check_sp(xp:4) > 0){
  security_hole(0);
}
