###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_nasl_detect_lin.nasl 854 2009-01-21 12:46:24Z jan $
#
# NASL Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900189);
  script_version("Revision: 1.0 ");
  script_name("NASL Version Detection (Linux)");
  desc = "
  Overview: This script detect the installed version of NASL and set the
  result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the KB for the version of NASL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

naslPort = 1241;
if(!get_tcp_port_state(naslPort)){
  exit(0);
}

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_file(file_name:"nasl",file_path:"/", useregex:TRUE,
                 regexpar:"$", sock:sock);
foreach naslBin (paths)
{
  naslVer = get_bin_version(full_prog_name:chomp(naslBin), sock:sock,
                            version_argv:"-version",
                            ver_pattern:"nasl ([0-9.a-z]+)");
  if(naslVer[1] != NULL)
  {
    set_kb_item(name:"NASL/Linux/Ver", value:naslVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
