###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_natterchat_sec_bypass_vul.nasl 4257 2009-08-26 15:38:09Z aug $
#
# NatterChat Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901004);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7047", "CVE-2008-7049");
  script_bugtraq_id(32395, 32385);
  script_name("NatterChat Security Bypass Vulnerability");
  desc = "
  Overview: The host is running NatterChat and is prone to Security Bypass
  vulnerability.

  Vulnerability Insight:
  - Vulnerability in the 'home.asp' script that fails to adequately secure
    access to administrative scripts.
  - Multiple SQL injection flaws in login.asp, which can be caused via the
    'txtUsername' parameter and 'txtPassword' parameter in a form generated by
    home.asp.

  Impact:
  Attackers can exploit this issue to view, add, modify or delete information
  in the back-end database or bypass security restrictions.

  Impact Level: Application

  Affected Software/OS:
  NatterChat version 1.1 on Windows.

  Fix: No solution or patch is available as on 26th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.natterchat.co.uk/index.asp

  References:
  http://www.milw0rm.com/exploits/7172
  http://www.milw0rm.com/exploits/7179
  http://xforce.iss.net/xforce/xfdb/46748
  http://xforce.iss.net/xforce/xfdb/46764

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the attack string and version of NatterChat");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_natterchat_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

nchatPort = get_http_port(default:80);
if(!nchatPort){
  exit(0);
}

nchatVer = get_kb_item("www/" + nchatPort + "/NatterChat");
nchatVer = eregmatch(pattern:"^(.+) under (/.*)$", string:nchatVer);

if((nchatVer[2] != NULL) && (!safe_checks()))
{
  sndReq = http_get(item:string(nchatVer[2], "/admin/home.asp"),
                    port:nchatPort);
  rcvRes = http_send_recv(port:nchatPort, data:sndReq);

  if("Natterchat Administration - Home" >< rcvRes)
  {
    security_hole(nchatPort);
    exit(0);
  }
}

if(nchatVer[1] != NULL)
{
  if(version_is_equal(version:nchatVer[1], test_version:"1.1")){
    security_hole(nchatPort);
  }
}
