###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openswan_detect.nasl 3120 2009-06-27 21:48:29Z jun $
#
# Openswan Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900387);
  script_version("$Revision: 1.0 $");
  script_name("Openswan Version Detection");
  desc = "
  Overview: This script detects the installed version of Openswan and
  sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Openswan");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

oswan_sock = ssh_login_or_reuse_connection();
if(!oswan_sock){
  exit(0);
}

paths = find_bin(prog_name:"ipsec", sock:oswan_sock);
foreach swanBin (paths)
{
  oswanVer = get_bin_version(full_prog_name:chomp(swanBin),
                             sock:oswan_sock, version_argv:"--version",
                             ver_pattern:"Openswan U(([0-9.]+)(rc[0-9])?)");
  if(oswanVer[1] != NULL)
  {
    set_kb_item(name:"Openswan/Ver", value:oswanVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
