###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_calendar_detect.nasl 6366 2009-12-29 12:41:24Z dec $
#
# PHP Calendar Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901089);
  script_version("Revision$: 1.0");
  script_name("PHP Calendar Version Detection");
  desc = "
  Overview: This script detects the installed version of PHP Calendar
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of PHP Calendar");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

calPort = get_http_port(default:80);
if(!calPort){
  exit(0);
}

foreach dir (make_list("/", "/php-calendar", "/calendar", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:calPort);
  rcvRes = http_send_recv(port:calPort, data:sndReq);
  if(("200 OK" >< rcvRes) && ("PHP-Calendar" >< rcvRes))
  {
    foreach path (make_list("/NEWS", "/docs/NEWS"))
    {
      sndReq = http_get(item:string(dir, path), port:calPort);
      rcvRes = http_keepalive_send_recv(port:calPort, data:sndReq, bodyonly:TRUE);
      if(("404 Not Found" >!< rcvRes) && ("calendar" >< rcvRes))
      {
        calVer = eregmatch(pattern:"(([0-9.]+).?([a-zA-Z0-9]+)?)", string:rcvRes);
        if(!isnull(calVer[1]))
        {
           Ver = ereg_replace(pattern:"-", replace:".", string:calVer[1]);
           set_kb_item(name:"www/" + calPort + "/PHP-Calendar", value:Ver + " under " + dir);
        }
      }
    }
  }
}
