###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_dba_replace_dos_vuln.nasl 4294 2009-08-26 14:10:24Z aug $
#
# PHP dba_replace Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900925);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-7068");
  script_bugtraq_id(33498);
  script_name("PHP dba_replace Denial of Service Vulnerability");
  desc = "

  Overview: The host is running PHP and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  An error occurs in 'dba_replace()' function while processing malformed
  user supplied data containing a key with the NULL byte.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code
  corrupt files and cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  PHP 4.x and 5.2.6 on all running platform.

  Fix: Upgrade to version 5.2.7 or later,
  http://www.php.net/downloads.php

  References:
  http://xforce.iss.net/xforce/xfdb/47316
  http://www.securityfocus.com/archive/1/archive/1/498746/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Grep for version 4.x and 5.2.6
if((phpVer =~ "^4") || version_is_equal(version:phpVer, test_version:"5.2.6")){
  security_warning(phpPort);
}

