###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_php_fusion_detect.nasl 1091 2009-03-19 17:05:29Z Feb $
#
# Detection of php_fusion Version
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################
if(description)
{
  script_id(900612);
  script_version("$Revision: 1.0 $");
  script_name("Detectintg the Version of php-fusion");
  desc = "
  Overview:This script finds the versiom of the php-fusion installed
  on remote sytem and sets the equivelent value in the KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Detects the version of php-fusion and sets the kb value");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
   exit(0);
}

foreach dir (make_list("/php-files", "/php-fusion/php-files" ,cgi_dirs()))
{

  sndReq = http_get(item:string(dir, "/news.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);

  if(rcvRes == NULL){
     exit(0);
  }

  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) && 
    ("PHP-Fusion Powered" >< rcvRes))
  {

    matchline = egrep(pattern:"v[0-9.]+", string:rcvRes);
    matchVersion = eregmatch(pattern:"> v([0-9.]+)", string:matchline);

    if(matchVersion[1]!= NULL)
    {
      set_kb_item(name:"www/"+ port + "/php-fusion",value:matchVersion[1]);
      exit(0);
     }
   }

  sndReq = http_get(item:string(dir, "/readme-en.html"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);

  if(rcvRes == NULL){
     exit(0);
   }

  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) && 
    ("PHP-Fusion Readme" >< rcvRes))
  {
    matchline = egrep(pattern:"Version:</b> [0-9.]+", string:rcvRes);
    matchVersion = eregmatch(pattern:"> ([0-9.]+)", string:matchline);
    if(matchVersion[1]!= NULL){
      set_kb_item(name:"www/"+ port + "/php-fusion",value:matchVersion[1]);
     }
     exit(0);  
   }
}
